XIncludeFile "tiles.pbi"

Procedure Masks_editor()
  If OpenWindow(#Window_tiles_editor, 0, 0, 197, 275, "Masks editor", #PB_Window_WindowCentered | #PB_Window_TitleBar, WindowID(#Window))
    Protected i.l = 0, img.l
    ListIconGadget(#TilesListIcon, #TilesListIcon_x, #TilesListIcon_y, #TilesListIcon_w, #TilesListIcon_h, "Mask", #TilesColumn1_w+5, #PB_ListIcon_FullRowSelect | #PB_ListIcon_AlwaysShowSelection)
    AddGadgetColumn(#TilesListIcon, 2, "ID", #TilesColumn2_w)
    AddGadgetColumn(#TilesListIcon, 3, "File", #TilesColumn3_w)
    If DatabaseQuery(#Database, "SELECT * FROM mask ORDER BY id;")
      While NextDatabaseRow(#Database)
        img = ImageID(LoadImage(#PB_Any, "masks\"+GetDatabaseString(#Database, 1)))
        AddGadgetItem(#TilesListIcon, -1, Chr(10)+Str(i)+Chr(10)+GetDatabaseString(#Database, 1), img)
        SetGadgetItemData(#TilesListIcon, i, img)
        i+1
      Wend
      FinishDatabaseQuery(#Database)
    Else
      MessageRequester("DatabaseUpdate() error", DatabaseError())
      End
    EndIf
    
    ButtonGadget(#UpButton, #UpButton_x, #UpButton_y, #UpButton_w, #UpButton_h, "Up")
    DisableGadget(#UpButton, 1)
    ButtonGadget(#DownButton, #DownButton_x, #DownButton_y, #DownButton_w, #DownButton_h, "Down")
    DisableGadget(#DownButton, 1)
    ButtonGadget(#AddButton, #AddButton_x, #AddButton_y, #AddButton_w, #AddButton_h, "Add")
    ButtonGadget(#RemoveButton, #RemoveButton_x, #RemoveButton_y, #RemoveButton_w, #RemoveButton_h, "Remove")
    DisableGadget(#RemoveButton, 1)
    ButtonGadget(#OKButton2, #OKButton2_x, #OKButton2_y, #OKButton2_w, #OKButton2_h, "Ok")
    ButtonGadget(#CancelButton2, #CancelButton2_x, #CancelButton2_y, #CancelButton2_w, #CancelButton2_h, "Cancel")

    Protected file.s, tiles_path.s = "masks\", filter.s = "mask (*.bmp)|*.bmp", ok.l = 0, quit.l = 0
    DisableWindow(#Window, 1)
    Repeat
      Select WaitWindowEvent()
        Case #PB_Event_Gadget
          Select EventGadget()
            Case #TilesListIcon
              If GetGadgetState(#TilesListIcon) <> -1
                If GetGadgetState(#TilesListIcon) <> 0
                  DisableGadget(#UpButton, 0)
                Else
                  DisableGadget(#UpButton, 1)
                EndIf
                If GetGadgetState(#TilesListIcon) <> CountGadgetItems(#TilesListIcon)-1
                  DisableGadget(#DownButton, 0)
                Else
                  DisableGadget(#DownButton, 1)
                EndIf
                DisableGadget(#RemoveButton, 0)
              Else
                DisableGadget(#UpButton, 1)
                DisableGadget(#DownButton, 1)
                DisableGadget(#RemoveButton, 1)
              EndIf
            Case #UpButton
              i = GetGadgetState(#TilesListIcon)
              AddGadgetItem(#TilesListIcon, i-1, Chr(10)+Chr(10)+GetGadgetItemText(#TilesListIcon, i, 2), GetGadgetItemData(#TilesListIcon, i))
              SetGadgetItemData(#TilesListIcon, i-1, GetGadgetItemData(#TilesListIcon, i+1))
              RemoveGadgetItem(#TilesListIcon, i+1)
              reindex()
              SetGadgetState(#TilesListIcon, i-1)
            Case #DownButton
              i = GetGadgetState(#TilesListIcon)
              AddGadgetItem(#TilesListIcon, i+2, Chr(10)+Chr(10)+GetGadgetItemText(#TilesListIcon, i, 2), GetGadgetItemData(#TilesListIcon, i))
              SetGadgetItemData(#TilesListIcon, i+2, GetGadgetItemData(#TilesListIcon, i))
              RemoveGadgetItem(#TilesListIcon, i)
              reindex()
              SetGadgetState(#TilesListIcon, i+1)
            Case #AddButton
              file = OpenFileRequester("Add mask...", tiles_path, filter, 0)
              If file
                img = ImageID(LoadImage(#PB_Any, file))
                AddGadgetItem(#TilesListIcon, -1, Chr(10)+Str(CountGadgetItems(#TilesListIcon))+Chr(10)+GetFilePart(file), img)
                SetGadgetItemData(#TilesListIcon, CountGadgetItems(#TilesListIcon)-1, img)
              EndIf
              SetGadgetState(#TilesListIcon, CountGadgetItems(#TilesListIcon)-1)
            Case #RemoveButton
              RemoveGadgetItem(#TilesListIcon, GetGadgetState(#TilesListIcon))
              reindex()
            Case #OKButton2
              ok = 1
              quit = 1
            Case #CancelButton2
              ok = 0
              quit = 1
          EndSelect
        Default
          Delay(10)
      EndSelect
    Until quit
    If ok
      If DatabaseUpdate(#Database, "DELETE FROM mask;")
        FinishDatabaseQuery(#Database)
        For i = 0 To CountGadgetItems(#TilesListIcon)-1
          If DatabaseUpdate(#Database, "INSERT INTO mask (id, sprite) VALUES ("+Str(i)+", '"+GetGadgetItemText(#TilesListIcon, i, 2)+"');")
            FinishDatabaseQuery(#Database)
          EndIf
        Next
      EndIf
    EndIf
    CloseWindow(#Window_tiles_editor)
    DisableWindow(#Window, 0)
    SetActiveWindow(#Window)
  EndIf
EndProcedure
; IDE Options = PureBasic 4.60 (Windows - x86)
; CursorPosition = 5
; Folding = -
; EnableXP
; UseMainFile = main.pb
; CurrentDirectory = ..\